% User Guide for Tactical Battle

[Allan Thompson link]: Allan Thompson/a beginners guide to map creation.md.html
[Carlos Macintosh link]: https://dl.dropboxusercontent.com/u/8252087/tips%20and%20tricks.html
[Craig Brett link]: Craig Brett/Readme.html
[Scripting Guide link]: Scripting.md.html
[Map Creation Guide link]: Map Creation Guide.md.html
[Changelog link]: Changelog.md.html

## Other Guides
Here is a list of the other guides you may find useful:

* [A beginners guide to map creation by Allan Thompson][Allan Thompson link]
* [Tips and tricks of the Map Pack trade by Carlos Macintosh][Carlos Macintosh link]
* [Map Creation Guide by Ian Reed][Map Creation Guide link]
* [Craig Brett's script documentation][Craig Brett link]
* [The Scripting Guide][Scripting Guide link]
* [The Changelog][Changelog link]

## Overview
This is the main menu user guide.
It describes the keys that are available in all maps and goes into great depth on how to create your own maps.
Each map pack has it's own user guide.  Consult the map pack user guides for additional help on understanding how each map pack is played.
If this is your first time playing Tactical Battle you should start with the Getting Started maps and be sure to read their user guide.

## Contact info
The latest version of Tactical Battle can be downloaded from http://BlindAudioGames.com
You may contact me at support@BlindAudioGames.com
Any suggestions about improving maps should be directed to the map creators.

## The mailing list
Consider joining the mailing list, some of the benefits are:

* Access to developer versions of the game so you can try out map creation features without waiting for the next full version.
* Find out about the latest features so your maps can take advantage of them.
* Let me know which features you'd like to see implemented and help me decide how to prioritize them.
* Access to the latest maps and the ability to give feedback to the map creators to help shape the final outcome.

To subscribe to the mailing list you can use the form in the "Joining the community" section of the BlindAudioGames.com website or simply send an email to:
ian-reeds-games-request@freelists.org
with the word subscribe in the subject line.

I hope to see you on the mailing list!

## Keys
If you find that remembering all these keys is difficult just remember that you can press F1 in the game at any time to get contextual help which will tell you the keys you can use in your current place in the game.

* control + L = Launch notepad with the last 50 spoken items in the speech log.
* F1 = cycle through contextual help.
* shift + F1 = cycle through contextual help in reverse.
* control + F1 = Launch this user guide in your web browser.
* control + shift + F1 = Launch the user guide for the current map pack.
* F2 = Speak the current menu or dialog caption.
* F3 = Announce current tile or menu item
* F4 = Announce detailed information for the unit on the current tile, also gives information about the current menu item if there is any.
* shift + F4 = Announce descriptions for the current unit, terrain and effects applied to either.
* F5 = Announce each item on the current tile.
* F8 = Replay the map intro.
* F11 = Raise music volume.
* shift + F11 = lower music volume.
* F12 = Mute or unmute music.  This can be helpful if you want to leave the game open while you do something else on your computer and need the music muted.
* Up / Down = move through menu items or up and down in the map.
* Right / Left = Adjust sliders in menus or move right and left in the map.
* Enter / Spacebar = Activate the current selection.  When used on a unit in the map it will bring up the unit menu with unit actions.
* Escape = Cancel the current action or get to the battle menu while in the map.
* Home, End, PageUp, PageDown = While in the map move to the left, right, top, or bottom edge of the map respectively.
* tab = Toggle to the next unit or structure on the current tile.  Also cycles through equipment slots when choosing an item to equip.
* shift + tab = Same as tab but in reverse order.
* shift + arrow keys = move the unit on the current tile.
* shift + Z = Move your review cursor back to the last unit who performed an action.
* shift + X = Move your review cursor back to the last unit who was the target of an action.
* shift + P = cycle through all the units that are possible targets of this skill.  Possible indicates they are within range and of the right team to have the skill cast on them.  Only useable after you've chosen a skill and now need to choose the target.
* shift + R = Rename the unit on the current tile.
* Control + E = End your turn.
* Control + R = Announce the current round.
* shift + T = Announce visible terrain the map creator has marked as special.
* shift + A = Announce which of your units still have points that allow them to perform actions.
* Period = Moves to the next friendly unit.
* Shift + Period = Moves to the previous friendly unit.
* Slash = Moves to the next enemy unit.
* Shift + Slash = Moves to the previous enemy unit.
* Semi-colon = Moves to the next friendly structure.
* Shift + Semi-colon = Moves to the previous friendly structure.
* Apostrophe (') = Moves to the next enemy structure.
* Shift + Apostrophe (') = Moves to the previous enemy structure.
* Right bracket (]) = Speech rate up.
* Shift + Right bracket (]) = Speech rate down.
* Left bracket ([) = zoom in.
* Shift + Left bracket ([) = zoom out
* Backslash = Speak next line in the speech log.
* Shift + Backslash = Speak previous line in the speech log.
* control + shift + A = toggle whether this unit is AI controlled or not, must be enabled by the map creator.
* control + A = Forces the AI to perform actions with this unit immediately.  The unit must be in an AI controlled state or you must be allowed to toggle it's AI state for this to work.

## Menus
Use up and down arrow keys to move through menu items.
Use Home and End to jump to the top or bottom of the menu respectively.
The menus also support first letter navigation which means when you press a letter you will be taken to the next item in the list that starts with that letter if there is one.

## Saving and loading
The game now supports saving and loading games which is great for when you are playing a large map or when you don't have a lot of time to spend in one sitting.
The save files are stored in the Data for TB\\Saved Games" folder.
There is currently no way to delete an old saved game from within Tactical Battle but you can do this from windows explorer since you know where they are located.

## Audio Settings
In the audio settings you can change music, sound and speech volume as well as speech rate and which SAPI 5 voice is used.
Use the left and right arrow keys to change the sliders.

## Preferences
The preferences menu has these options:

* announce coordinates when AI uses skills, this is on by default but can be disabled if you feel the coordinates of what the AI is doing is not helpful or too verbose.
* Y coordinates increase as you move up, this is off by default and Y coordinates increase as you move down which is how it works in the programming world.  Change it to on if you prefer a coordinate system that matches normal mathematics.

Use the left and right arrow keys to change the sliders.

## Counting rounds and turns
A round is a sequence in which all teams take a turn. 
A turn is when any individual team is performing actions. 

When you see an effect with 3 rounds remaining it means that it will fizzle after 3 rounds have passed and it becomes the turn when the effect was created.
When you see an effect that has 0 rounds remaining it means it will fizzle this round when it becomes the turn on which it was created.

##Online multiplayer

As of Tactical Battle 3.0, you can now take your battles online against friends, family and foes from across the world. Simply select the "online multiplayer" option in the main menu.

If this is your first time logging in, you will be asked to choose an alias. Pick one that uniquely identifies you. No profanities or hatred, please. Keep it all friendly, relatively. 

After this, you will be taken to the multiplayer menu. Here you will have the option to create a new game, join an already existing game or view who is online. 

Note, that at almost any time whilst online, you may send and receive chat messages with other online users. To send a message, simply hold shift and press enter to go into the chat message entry screen. Type out your message and press enter to send it. You will automatically receive messages with no action on your part.

###Creating a game

If you have a particular game and map pack in mind, select the create a game option. 

You will be asked to pick a name and a map for your online game. The game name could be something descriptive, such as "Axis and Allies" online", but its really up to you. Again, play nice. You may pick any map from any map pack you have downloaded that has been marked ready for multiplayer by its author. If you have a map pack that you think could be made for multiplayer but isn't, please contact the author and ask them if they'd consider it. Once you've picked the game name and map, create the game.

You will now be dropped in the lobby. Once here, your game will be joinable by other players. Any players that choose "join a game" will see your game and may join. You may now choose your slot, what team you will play as. Pick a player slot and team and press enter to pick it for yourself. As a game creater, you must be one of the players in a game to start. 

All slots must be filled, either by human players, or with artificial intelligence. To assign Ai to a slot, highlight it and press shift+A, and AI will be assigned to that slot. Human players will now not be able to take this slot unless you remove the AI from that slot. To remove AI from a slot that it is in, press shift+A again. 

Once all slots are filled and things are to your liking, hit the start game option, and battle will begin!

###Joining an existing game

To join an already running game, hit the "join a game" option. You will then see the list of running games, if any.

This list will only contain map packs which you already own. If you fear you may be missing out on some online games, go to the "download a map campaign" option in the main menu and grab any map packs you might be interested in. These will then show up if you go online and use "join a game".

If you find a game you are interested in joining, hit enter to attempt to join. If the game has already started, you will be unable to join. Otherwise, you will be dropped into the lobby. 

Once in the lobby, you may pick a player slot to take for yourself. Once you've picked a tema that you'd like to play as, simply wait for the host of the game to start it, and battle will begin.

## Map Creation
My new focus with Tactical Battle is to make it an engine for map creators to create their own maps with cool themes and interesting ways of beating each map.
Anyone can become a map creator.  You don't need to be a programmer.
If you're interested check out the following guides:

* [A beginners guide to map creation by Allan Thompson][Allan Thompson link]
* [Tips and tricks of the Map Pack trade by Carlos Macintosh][Carlos Macintosh link]
* [Map Creation Guide by Ian Reed][Map Creation Guide link]

## Final notes
If you enjoy the game be sure to tell others about it.
The larger the Tactical Battle community becomes the more map creators and scripters there will be.
And this means more interesting themes and maps for you to play.

I'd like to give a big thanks to all the map creators and scripters who volunteer their time to make the game so good.

Written by Ian Reed
